void setup () {             // Zwei Schrägstriche: Alles, was von hier bis zum Zeilenende geschrieben wird, ist ein Kommentar und wird vom Arduino nicht beachtet.
                            // Alle Befehle, die innerhalb der geschweiften Klammern vom setup () stehen, werden ein Mal ausgeführt.
                
  pinMode (6, OUTPUT);      // Pin 6 wird als OUTPUT definiert. An OUTPUTs kann der Arduino entweder 5V (High) oder 0V (Low) anlegen.

  }                         // Ende des Setups.


void loop () {              // Start der Schleife. Alles, was innerhalb der Loop steht, wird als Schleife ausgeführt.
  
  digitalWrite (6, HIGH);   // Befehl, der Pin 6 auf HIGH - d.h. 5V - setzt
  delay (1000);             // delay pausiert den Arduino für den Wert in Milli-Sekunden
  digitalWrite (6, LOW);    // Befehl, der Pin 6 auf LOW - d.h. 0V - setzt
  delay (1000);              

  }                         // Ende der Schleife. Die Schleife wird jetzt wieder von vorne durchlaufen.



/*  P1_LED-Blinken_14.05.2019
 
    **********************************************************
    AUFGABEN (Hinweise und Lösungen finden Sie am Ende!)
    **********************************************************
   

    1   VORBEREITUNG - Laden Sie dieses Programm unverändert auf den Aruino hoch. Wenn alles geklappt hat, blinkt die LED. 

  
    2   EINSTIEG (Partneraufgabe) - Machen Sie sich mit dem Programmcode vertraut. 
        Erklären Sie einer Person den Aufbau des Programms und die einzelnen Programmfunktionen mit eigenen Worten.


    3   BLINKGESCHWINDIGKEIT - Lassen Sie die LED schneller blinken. Ändern Sie hierfür den Programmcode und übertragen Sie ihn anschließend auf den Arduino. 
        
        Tipp: Wo im Programm steht ein Wert für die Zeit? Ändern Sie diesen und laden das Programm wieder auf den Arduino.


    4   AUFLÖSUNGSFÄHIGKEIT I - Bestimmen Sie die zeitliche Auflösungsfähigkeit des menschlichen Auges (Wahrnehmungsschwelle). 
        Erhöhen Sie hierfür schrittweise die Blinkfrequenz der LED, bis das Blinken nicht mehr von einem Dauerleuchten zu unterscheiden ist. 

   
    5   AUFLÖSUNGSFÄHIGKEIT II (Partneraufgabe) - Testen Sie mit anderen Personen, ob diese Schwelle bei unterschiedlichen Personen identisch ist.


    6   WEITERE LEDS - Verschalten Sie eine weitere LED mitsamt Vorwiderstand mit dem Arduino (z.B. an PIN 10) und lassen Sie beide LEDs im Wechsel blinken. 
        
        Tipp: Sie müssen unter >> void setup << definieren, an welchem Port die zusätzliche LED angesteuert wird und wie sich der Port verhalten soll. Kopieren Sie die entsprechenden Befehle und passen Sie sie an.


    7   DIMMEN VON LEDS - Dimmen Sie die LED zunächst, anstatt sie direkt auszuschalten. Dieses funktioniert nur an den PWM-Ausgängen des Arduino. Diese sind auf dem Arduino an der kleinen Wellenlinie zu erkennen.
        Verwenden Sie dazu den Befehl  >> analogWrite(6, 100); << und spielen Sie mit den letzten Wert (0-255).


    8   MORSECODE I - Lassen Sie den Arduino Ihren Namen oder ein beliebiges Wort (z.B. SOS) morsen. Eine Tabelle mit Morsecodes finden Sie auf dem Begleitblatt oder z.B. unter en.wikipedia.org/wiki/Morse_code

  
    9   MORSECODE II (Partneraufgabe) - Lassen Sie eine Person einen (kurzen) Morsecode entschlüsseln (dekodieren). 


    10  FUNKTIONEN - Das Morseprogramm ist sicher sehr lang und unübersichtlich. Es wäre übersichtlicher wenn man direkt DITs und DAHs (d.h. kurze und lange LED-Morse-Zeichen) aufrufen könnte. 
    
        Definieren Sie dazu im Quellcode DIT und DAH als Funktion. Fügen Sie dazu außerhalb von >> void loop() { ... } << für DIT folgendes ein:

        void DIT() {
        *Befehle, um LEDs an- und auszuschalten*   
        }

        Anschließend können Sie diesen Code an einer beliebien Stelle innerhalb von z.B. void loop mit >> DIT(); << aufrufen 
        und Morsecodes mit DIT();DIT();DIT(); usw. ausführen. Verfahren Sie genauso mit einer Funktion für DAH();

  
    
    **********************************************************
    LÖSUNGSHINWEISE
    **********************************************************

    3   BLINKGESCHWINDIGKEIT - LÖSUNGSHINWEISE
    
        - Nach jeder Änderung im Programmcode muss dieser erneut übertragen werden!
        - Das Blinken der LED läuft wie folgt ab: LED einschalten, warten, LED ausschalten, warten, wiederholen. 
        - Ändern Sie beide Werte, die das Programm zwischen ein- und ausschalten wartet. 
        - Die Zeitdauer wird in Millisekunden angegeben, für eine halbe Sekunde schreiben Sie bspw. delay(500);
        - Gibt es eine Fehlermeldung? Haben Sie vlt. ein Semikolon ; am Ende der Befehlszeile vergessen?
        - geht vor lauter Fehlermeldungen gar nichts mehr? Laden Sie das Programm erneut.


    4   AUFLÖSUNGSFÄHIGKEIT I - LÖSUNGSHINWEISE
    
        - Ändern Sie die Werte bei delay. Das zeitliche Auflösungsvermögen des menschlichen Auges liegt zwischen 30 und 70 Ereignissen pro Sekunde.





    7   DIMMEN VON LEDS - Der Befehl für Dimmen lautet analogWrite(6, 100); er kann zusammen mit einem kurzen delay hinter den Befehl >> digitalWrite (6, HIGH); << eingefügt werden. 
        Experimentieren Sie mit verschiedenen Werten und bauen den Befehl mehrmals und verringern Sie so schrittweise die Helligkeit.


  
    
    **********************************************************
    LÖSUNGEN
    **********************************************************

    3   BLINKGESCHWINDIGKEIT - LÖSUNG: 
    
        Ändern Sie den Wert bei delay. Um die LED schneller blinken zu lassen, muss die Pause zwischen dem Blinken verringert werden, bspw. >>  delay (200); <<  

   
    4   AUFLÖSUNGSFÄHIGKEIT I - LÖSUNG
    
        fügen Sie unter >> void setup << folgenden Code hinzu: 
        >> pinMode (10, OUTPUT);  <<
        fügen Sie unter >> void loop << folgenden Code hinzu: 
        digitalWrite (10, HIGH); 
        delay (500);
        digitalWrite (10, LOW);


    10  FUNKTIONEN - LÖSUNG
    
        Fügen Sie unterhalb der loop-Schleife ein:

        void DIT() {
          digitalWrite (6, HIGH);   
          delay (200);              
          digitalWrite (6, LOW);    
          delay (500);              
        }

        void DAH() {
          digitalWrite (6, HIGH);   
          delay (500);              
          digitalWrite (6, LOW);    
          delay (500);              
        }

        Benutzen Sie anschließend innerhalb der loop-Schleife die Befehle DIT(); bzw. DAH();, 
        z.B. >> DIT();DIT();DIT();DAH();DAH();DAH();DIT();DIT();DIT(); << für das Morsezeichen SOS


*/
